#ifndef HEADER_INCLUDED
#define HEADER_INCLUDED

#define	FM_IF			 107000		// oscillator offset (FM-IF)
#define FREQ_MIN		 875000
#define FREQ_MAX		1080000
#define FREQ_STEP_x10		125		// tenfold step width (for return values: freq[Hz]/100)


/*===============================================================
	RDS error codes
===============================================================*/	
#define RDS_OK						  0x00000000

// hardware errors
//-----------------------------------------------------------------------------
#define RDS_ERROR_IIC_READ	          0x00000002
#define RDS_ERROR_IIC_WRITE	          0x00000004
#define RDS_ERROR_NO_DAVN			  0x00000008

// hardware detection errors
//-----------------------------------------------------------------------------
#define RDS_ERROR_SAA6588_NO_RESPONSE 0x00000100
#define RDS_ERROR_OM5610_NO_RESPONSE  0x00000200
// RDS_ERROR_TV_NO_CONNECT: returned if the TV DLL could not initialize the TV card
#define RDS_ERROR_TV_NO_CONNECT       0x00000400
#define RDS_ERROR_DEVICE_NOT_FOUND	  0x00000800

// RDS errors
//-----------------------------------------------------------------------------
#define RDS_NO_DAVN					  0x00001000
#define RDS_INCORRECTABLE_BLOCK		  0x00002000
#define RDS_AF_INVALID_CODE			  0x00004000
#define RDS_AF_LIST_SIZE			  0x00008000

// search errors
//-----------------------------------------------------------------------------
// RDS_ERROR_INVALID_FREQUENCY: 
// returned if the frequency read from the hardware is invalid
#define RDS_ERROR_INVALID_FREQUENCY   0x00010000
// RDS_ERROR_TIMEOUT: 
// returned if the tuner search couldn't find a station in time
#define RDS_ERROR_TIMEOUT             0x00020000
#define RDS_ERROR_TOO_CLOSE           0x00040000
#define RDS_ERROR_NO_STATION_FOUND    0x00080000

// general errors
//-----------------------------------------------------------------------------
// RDS_ERROR_NOT_SUPPORTED: 
// returned if a function cannot be carried out due to the installed hardware
#define RDS_ERROR_NOT_SUPPORTED		  0x10000000 
#define RDS_ERROR_INVALID_PARAMETER	  0x20000000	
#define RDS_ERROR					  0xFFFFFFFF



typedef struct tagREAD_RETURN// accesses the shift register either as
{   						// DWORD or bit field
 	DWORD		SR;			
	BOOL		fStereo;	// 1 - mono ,0 - stereo
	BOOL		fLock;		// 1 - not locked, 0 - locked
}READ_RETURN; 



#endif