/*=============================================================================
   FILE:         TestAppDlg.cpp
-------------------------------------------------------------------------------
   DESCRIPTION:  CAboutDlg class implementation
   AUTHOR:       F.M.Birth
   HISTORY:      3-8-1999 completely overworked version
   NOTES:        
-------------------------------------------------------------------------------
   COPYRIGHT:    (c) 1999, TerraTec Electronic GmbH. All Rights Reserved.

                 Information in this file is the intellectual property of
                 TerraTec Electronic GmbH, and contains trade secrets
                 that must be stored and viewed confidentially.
                 By viewing, using, modifying and compiling 
                 the programming code below you acknowledge you have read,
                 accepted and executed the Software licensing agreement 
                 your company has established with TerraTec Electronic GmbH.
=============================================================================*/

#include "stdafx.h"
#include <WinSvc.h>
#include <MmSystem.h>
#include <WinIoctl.h>


#include "TestSet.h"
#include "Ar_Ioctl.h"
#include "TestApp.h"
#include "TestAppDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


void CALLBACK TimerCallBack(UINT wID, UINT wMsg,DWORD dwUser, DWORD dw1, DWORD dw2);

/*----------------------------------------------------------------------------
	GLOBALS
-----------------------------------------------------------------------------*/
BOOL   gfNewFreq = TRUE;
UCHAR  gbRDSRead[7];
OSVERSIONINFO	  OS;


#define DEFAULT_FREQ 912750 //1048000
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTestAppDlg dialog

CTestAppDlg::CTestAppDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTestAppDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTestAppDlg)
	m_CurVolume = 0;
	m_CurFreq = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CTestAppDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTestAppDlg)
	DDX_Control(pDX, IDC_FREQ_SLIDER, m_cSliderFreq);
	DDX_Text(pDX, IDC_EDIT_PS, m_PS);
	DDX_Text(pDX, IDC_EDIT_RDS_CURBLOCK, m_CurBlock);
	DDX_Text(pDX, IDC_EDIT_RDS_PREVBLOCK, m_PrevBlock);
	DDX_Slider(pDX, IDC_VOL_SLIDER, m_CurVolume);
	DDX_Text(pDX, IDC_EDIT_FREQ, m_CurFreq);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTestAppDlg, CDialog)
	//{{AFX_MSG_MAP(CTestAppDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_HSCROLL()
	ON_CBN_SELCHANGE(IDC_COMBO_CARDS, OnSelchangeCards)
	ON_BN_CLICKED(IDC_BUTTON_SET_FREQ, OnButtonSetFreq)
	ON_BN_CLICKED(IDC_SEARCH_UP, OnSearchUp)
	ON_BN_CLICKED(IDC_SEARCH_DOWN, OnSearchDown)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTestAppDlg message handlers


/*=============================================================================
  Function    : CTestAppDlg::OnInitDialog
-------------------------------------------------------------------------------
  Description : 
  Returns     : BOOL   
-------------------------------------------------------------------------------
  Notes       : 
=============================================================================*/
BOOL CTestAppDlg::OnInitDialog()
{
	int     i;
	CString szTmp;

	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.
	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	

	/*----------------------------------------------------------------------------
		Get Operating System
	-----------------------------------------------------------------------------*/

	OS.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	if (!GetVersionEx(&OS))
		AfxMessageBox("Could not determine Operating system");

	/*----------------------------------------------------------------------------
		Initialize members
	-----------------------------------------------------------------------------*/
	m_wTimerID	= 0;

	m_PS		= "No RDS";
	m_CurBlock	= "0x 00 00";
	m_PrevBlock	= "0x 00 00";
	UpdateData(FALSE);
	
	/*----------------------------------------------------------------------------
		Initialize sliders
	-----------------------------------------------------------------------------*/
	m_cSliderFreq.SetRange(875000,1080000);
	m_cSliderFreq.SetLineSize(500);
	m_cSliderFreq.SetPageSize(5000);
	m_cSliderFreq.SetTicFreq(10000);
	m_cSliderFreq.SetPos(DEFAULT_FREQ);
	m_CurFreq = DEFAULT_FREQ;
	

	CSliderCtrl* pSlider; 
	pSlider = (CSliderCtrl*)GetDlgItem(IDC_VOL_SLIDER);
	pSlider->SetRange(0,127);
	pSlider->SetTicFreq(16);
	m_CurVolume = 127;
	UpdateData(FALSE);


	/*----------------------------------------------------------------------------
		Initialize the hardware and drivers
	-----------------------------------------------------------------------------*/
	
	if (LoadDriver() != 0)
		PostQuitMessage(-1);

	if (InitHwDevices(&m_HwData) == FALSE)
	{
		CleanupHwDevices(&m_HwData);	// close devices
		PostQuitMessage(-2);
	}

	CComboBox* pComboCards = (CComboBox*) GetDlgItem(IDC_COMBO_CARDS);
	for (i=0;i<m_HwData.nNoCards;i++)
	{
		szTmp.Format("Card %d (Hardware ID = %d)",i,m_HwData.HwInst[i].HW_ID);
		pComboCards->AddString(szTmp);
	
	}
	
	pComboCards->SetCurSel(0);
	m_HwData.nCurCardIdx = 0;
	OnSelchangeCards();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTestAppDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		if (nID == SC_CLOSE)
			OnClose();
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CTestAppDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CTestAppDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


/*=============================================================================
  Function    : TimerCallBack
-------------------------------------------------------------------------------
  Description : Callback routine for timeSetEvent()
  Returns     : void 
  Parameters  : UINT wID -> 
              : UINT wMsg -> 
              : DWORD dwUser -> IN: should be filled with a pointer to this dialog object
              : DWORD dw1 -> 
              : DWORD dw2 -> 
-------------------------------------------------------------------------------
  Notes       : This routine is static which means that we cannot access all members.
                Dialog class. Therefore we call a member function.
=============================================================================*/
void CALLBACK TimerCallBack(UINT wID, UINT wMsg,DWORD dwUser, DWORD dw1, DWORD dw2)
{
	CTestAppDlg* pDlg= (CTestAppDlg*) dwUser;
	pDlg->GetRdsData();
}


/*=============================================================================
  Function    : CTestAppDlg::GetRdsData
-------------------------------------------------------------------------------
  Description : acquires RDS data and decodes PI and PS
  Returns     : BOOL  -> TRUE/FALSE
-------------------------------------------------------------------------------
  Notes       : 
=============================================================================*/
BOOL CTestAppDlg::GetRdsData()
{
	static WORD	wFrame[4] = {0,0,0,0}; 
	static BOOL fValidFrame;
	static WORD wPI = 0;
	static char PS[9],PSBak[9] ="--------";

	char        szString[20];
	int			nCharCnt;
	ULONG		ReturnedLength;
	BOOL        fRet;
	
	if(gfNewFreq)
	{
		strcpy(PS,"--------");
		gfNewFreq = FALSE;
	}

    fRet = DeviceIoControl(m_HwData.hDriver[m_HwData.nCurCardIdx],
						IOCTL_SAA6588_READ_IIC,
						NULL,0,
						gbRDSRead,7,
						&ReturnedLength,NULL);

	if (!fRet)
		return FALSE;


	/*----------------------------------------------------------------------------
		Display undecoded data
	-----------------------------------------------------------------------------*/
/*
	sprintf(szString,"0x %02X %02X", gbRDSRead[1],gbRDSRead[2]);
	GetDlgItem(IDC_EDIT_RDS_CURBLOCK)->SetWindowText(szString);

	sprintf(szString,"0x %02X %02X", gbRDSRead[3],gbRDSRead[4]);
	GetDlgItem(IDC_EDIT_RDS_PREVBLOCK)->SetWindowText(szString);
*/
	
	/*----------------------------------------------------------------------------
		Decode some RDS data
	-----------------------------------------------------------------------------*/
	
	BYTE bBlock = gbRDSRead[0]>>5;
	switch(bBlock)
	{
	case 0:

		if (gbRDSRead[0] & 0x03)
		{
			fValidFrame = FALSE;
			break;
		}
		wFrame[0] = (((WORD)gbRDSRead[1])<<8) + (WORD)gbRDSRead[2];
		
		// update display only if necessary
		if (wFrame[0] != wPI)
		{
			sprintf(szString,"%02X %02X", gbRDSRead[1],gbRDSRead[2]);
			GetDlgItem(IDC_EDIT_PI)->SetWindowText(szString);
			wPI = wFrame[0];
		}
		break;
	case 1:
		if (gbRDSRead[0] & 0x03)
		{
			fValidFrame = FALSE;
			break;
		}
		wFrame[1] = (((WORD)gbRDSRead[1])<<8) + (WORD)gbRDSRead[2];
		break;
	case 2:
		if (gbRDSRead[0] & 0x03)
		{
			fValidFrame = FALSE;
			break;
		}
		wFrame[2] = (((WORD)gbRDSRead[1])<<8) + (WORD)gbRDSRead[2];
		break; 

	case 3:
		if ((gbRDSRead[0] & 0x03) == 0)
		{	// decode PS
			switch((wFrame[1] & 0xF000) )
			{
			case 0x0000:	// PS
				if (fValidFrame == FALSE)
					break;
				wFrame[3] = (((WORD)gbRDSRead[1])<<8) + (WORD)gbRDSRead[2];
				nCharCnt = wFrame[1] & 0x0003;

				PS[2*nCharCnt]   = wFrame[3]>>8;
				PS[2*nCharCnt+1] = wFrame[3]&0x00FF;

				if (strcmp(PS,PSBak)!=0)
				{
					GetDlgItem(IDC_EDIT_PS)->SetWindowText(PS);
					strcpy(PSBak,PS);
				}
				break;
			}
		}
		fValidFrame = TRUE;
		break;
	}

	return TRUE;
}



/*=============================================================================
	OnClose
=============================================================================*/
void CTestAppDlg::OnClose() 
{
	if (m_wTimerID != 0)
	{
		timeKillEvent(m_wTimerID);
		m_wTimerID = 0;
	}
	CleanupHwDevices(&m_HwData);

}

/*=============================================================================
	OnClose
=============================================================================*/
void CTestAppDlg::OnButtonSetFreq() 
{
	UpdateData(TRUE);
	SetFrequency(m_CurFreq);
	CSliderCtrl* pSlider;
	pSlider = (CSliderCtrl*)GetDlgItem(IDC_FREQ_SLIDER);
	pSlider->SetPos(m_CurFreq);
	m_PS = "--------";
	gfNewFreq = TRUE;

	UpdateData(FALSE);
}

void CTestAppDlg::OnButtonGetFreq() 
{
	ULONG ReturnedLength;
	WORD wState;
	GetFrequency();

	// Get State
	BOOL fRet = DeviceIoControl(m_HwData.hDriver[m_HwData.nNoCards],
                                IOCTL_OM5610_GET_STATE,
								NULL,0,
								&wState,sizeof(wState),
								&ReturnedLength,NULL);

	CheckDlgButton(IDC_AFC,wState>>8);
	CheckDlgButton(IDC_STEREO,wState & 0x00FF);

}


/*=============================================================================
  Function    : CTestAppDlg::InitHwDevices
-------------------------------------------------------------------------------
  Description : 
  Returns     : BOOL  -> 
  Parameters  : HW_DATA *pHwData -> 
-------------------------------------------------------------------------------
  Notes       : 
=============================================================================*/
BOOL CTestAppDlg::InitHwDevices(HW_DATA *pHwData)
{
	HANDLE hDriver;
	BOOL   fRet;
	ULONG  dwRetBytes;
	char   szBuffer[150];

    hDriver = CreateFile(
                   "\\\\.\\ActiveRadio0",           // Open the Device "file"
                    GENERIC_WRITE|GENERIC_READ,
                    FILE_SHARE_WRITE|FILE_SHARE_READ,
                    NULL,
                    OPEN_EXISTING,
                    0,
                    NULL);

    if (hDriver == INVALID_HANDLE_VALUE)        // Was the device opened?
    {
		int nError = GetLastError();
		// 2L ->ERROR_FILE_NOT_FOUND
		AfxMessageBox("Unable to open the device.\nApplication will now exit!");
        exit(1);
    }

	/*----------------------------------------------------------------------------
		Let us get the hardware info
	-----------------------------------------------------------------------------*/

    fRet = DeviceIoControl(hDriver,
						IOCTL_FIND_RADIO,
						NULL,0,
						pHwData,sizeof(HW_DATA),
						&dwRetBytes,NULL);
	if (!fRet)
	{
		ASSERT(0);
		TRACE("InitHwDevices -> IOCTL_FIND_RADIO failed!\n");
		return FALSE;
	}

	// Store the device handle away
	pHwData->hDriver[0]  = hDriver;
	pHwData->nCurCardIdx = 0;


	if (pHwData->nNoCards > 1)
	{
		for (int i=1;i<pHwData->nNoCards;i++)
		{
			sprintf(szBuffer,"\\\\.\\ActiveRadio%d",i);
			pHwData->hDriver[i] = CreateFile(szBuffer,
							GENERIC_WRITE|GENERIC_READ,
							FILE_SHARE_WRITE|FILE_SHARE_READ,
							NULL,
							OPEN_EXISTING,
							0,
							NULL);

			if (pHwData->hDriver[i] == INVALID_HANDLE_VALUE)        // Was the device opened?
			{
				int nError = GetLastError();
				pHwData->hDriver[i] = NULL;
				sprintf (szBuffer,"Unable to open the device no %d.\nApplication will now exit!",i);
				AfxMessageBox(szBuffer);
				// FMB TODO: call cleanup routine to unload the driver
				exit(1);
			}
		} // end for
	}

	return TRUE;
}


/*=============================================================================
  Function    : CTestAppDlg::CleanupHwDevices
-------------------------------------------------------------------------------
  Description : 
  Returns     : BOOL  -> 
  Parameters  : HW_DATA *pHwdata -> 
-------------------------------------------------------------------------------
  Notes       : 
=============================================================================*/
BOOL CTestAppDlg::CleanupHwDevices(HW_DATA *pHwdata)
{
	for (int i=0;i<m_HwData.nNoCards;i++)
	{
		if (m_HwData.hDriver[i] != NULL)
		{
			CloseHandle(m_HwData.hDriver[i] );
			m_HwData.hDriver[i] = NULL;
		}

	}
	return TRUE;
}



/*=============================================================================
//   LoadDriver() - load driver
-------------------------------------------------------------------------------
//   Inputs:  deviceNumber - device number to load (Windows95 only)
//   Outputs: return() - 0 OK, otherwise exit code
=============================================================================*/
LONG CTestAppDlg::LoadDriver()
{
	SC_HANDLE hManager, hService;       // For Service handles
    DWORD error;                        // For error code

    /*-------------------------------------------------------------------------
		Open the System Service Manager
	-------------------------------------------------------------------------*/
    if ( (hManager = OpenSCManager(NULL, NULL,
                    GENERIC_READ|GENERIC_WRITE|GENERIC_EXECUTE)) == NULL )
    {   
	  // failed getting to Service Manager
      switch ((error = GetLastError()))
      {
        case ERROR_ACCESS_DENIED:			break;
        case ERROR_DATABASE_DOES_NOT_EXIST: break;
        case ERROR_INVALID_PARAMETER:       break;
		case ERROR_CALL_NOT_IMPLEMENTED:    break;	// 120L (only valid in NT mode)
        default:				            break;
      }
	  AfxMessageBox("OpenSCManager failed!");
	  return(-1);
    }

    /*-------------------------------------------------------------------------
		Get a handle to the TTRadio Driver service
	-------------------------------------------------------------------------*/
    if ( (hService = OpenService(hManager, "TTRadio",
                    GENERIC_READ|GENERIC_WRITE|GENERIC_EXECUTE)) == NULL )
    {   // failed getting to WinRT service
      switch ( (error = GetLastError()) )      // - error
      {
        case ERROR_ACCESS_DENIED:           break;
        case ERROR_INVALID_HANDLE:          break;
        case ERROR_INVALID_NAME:            break;
		case ERROR_SERVICE_DOES_NOT_EXIST:	break;	// 1060
        default:				            break;
      }
	  AfxMessageBox("OpenService failed!");
      CloseServiceHandle(hManager);
      return(-1);
    }

    /*-------------------------------------------------------------------------
		Start the TTRadio driver
	-------------------------------------------------------------------------*/
    if ( !StartService(hService, 0, NULL) )  // Start the service
    {   // failed to start
	  error = GetLastError();
      switch ( error )      // - error
      {
	  case ERROR_SERVICE_ALREADY_RUNNING: // 1056L
	  // if service is already running - that's OK for us
		  CloseServiceHandle(hManager);       // Close out handles
  		  CloseServiceHandle(hService);
		  TRACE("StartService: ERROR_SERVICE_ALREADY_RUNNING!");
		  return 0;	// no error!
      case ERROR_ACCESS_DENIED:             break;
      case ERROR_INVALID_HANDLE:            break;
      case ERROR_PATH_NOT_FOUND:            break;
      case ERROR_SERVICE_DATABASE_LOCKED:   break;
      case ERROR_SERVICE_DEPENDENCY_DELETED:break;
      case ERROR_SERVICE_DEPENDENCY_FAIL:   break;
      case ERROR_SERVICE_DISABLED:          break;
      case ERROR_SERVICE_LOGON_FAILED:      break;
      case ERROR_SERVICE_MARKED_FOR_DELETE: break;
      case ERROR_SERVICE_NO_THREAD:         break;
      case ERROR_SERVICE_REQUEST_TIMEOUT:   break;
      }
      AfxMessageBox("StartService: ERROR!");
    }

    CloseServiceHandle(hManager);       // Close out handles
    CloseServiceHandle(hService);
    return(0);

}

/*=============================================================================
//   UnloadDriver() - Unload driver
-------------------------------------------------------------------------------
//   Inputs:  deviceNumber - device number to load (Windows95 only)
//   Outputs: return() - 0 OK, otherwise exit code
//   Notes: Define _WIN95 for Windows95 version
=============================================================================*/
LONG CTestAppDlg::UnloadDriver()
{

    SC_HANDLE hManager, hService;       // For Service handles
    SERVICE_STATUS ss;                  // For call
    DWORD error;                        // For error code

	/*-----------------------------------------------------------------------------
		Open the System Service Manager
	-----------------------------------------------------------------------------*/
    if ( (hManager = OpenSCManager(NULL, NULL,
                    GENERIC_READ|GENERIC_WRITE|GENERIC_EXECUTE)) == NULL )
	{ 
	  error = GetLastError();  
      switch (error)
      {
        case ERROR_ACCESS_DENIED:            break;
        case ERROR_DATABASE_DOES_NOT_EXIST:  break;
        case ERROR_INVALID_PARAMETER:        break;
        default:				             break;
      }
      AfxMessageBox("OpenSCManager: ERROR!");
      return(-1);
    }

	/*-----------------------------------------------------------------------------
		Get a handle to the WinRT Driver service
	-----------------------------------------------------------------------------*/
    if ( (hService = OpenService(hManager, "TTRadio",
                    GENERIC_READ|GENERIC_WRITE|GENERIC_EXECUTE)) == NULL )
  {   
	  error = GetLastError();  
      switch (error)
      {
        case ERROR_ACCESS_DENIED:              break;
        case ERROR_INVALID_HANDLE:             break;
        case ERROR_INVALID_NAME:               break;
        case ERROR_SERVICE_DOES_NOT_EXIST:     break;
        default:                               break;
      }
      AfxMessageBox("OpenService: ERROR!");
      CloseServiceHandle(hManager);
      return(-1);
    }

	/*-----------------------------------------------------------------------------
		Stop the WinRT Driver service
	-----------------------------------------------------------------------------*/
    if (!ControlService(hService, SERVICE_CONTROL_STOP, &ss) ) 
    {
	  error = GetLastError();
      switch (error)       // - error
      {
        case ERROR_SERVICE_NOT_ACTIVE:			
			  AfxMessageBox("ControlService: ERROR_SERVICE_NOT_ACTIVE!");
			  CloseServiceHandle(hManager);    // Close out handles
			  CloseServiceHandle(hService);
			  return(-1);

        case ERROR_ACCESS_DENIED:				break;
        case ERROR_INVALID_HANDLE:				break;
        case ERROR_DEPENDENT_SERVICES_RUNNING:	break;
        case ERROR_INVALID_SERVICE_CONTROL:		break;	// 1052
        case ERROR_SERVICE_CANNOT_ACCEPT_CTRL:	break;
        case ERROR_SERVICE_REQUEST_TIMEOUT:		break;
        default:								break;
      }
      AfxMessageBox("ControlService: ERROR!");
      CloseServiceHandle(hManager);    // Close out handles
      CloseServiceHandle(hService);
      return(-1);
    }
    CloseServiceHandle(hManager);       // Close out handles
    CloseServiceHandle(hService);
    return(0); 

}


/*=============================================================================
  Function    : CTestAppDlg::SetVolume
-------------------------------------------------------------------------------
  Description : 
  Returns     : DWORD  -> RDS_OK,RDS_ERROR 
  Parameters  : WORD wVol -> 0..127
-------------------------------------------------------------------------------
  Notes       : only works with Standalone card
=============================================================================*/
DWORD CTestAppDlg::SetVolume(WORD wVol)
{                        
	BOOL	fRet;
    ULONG   ReturnedLength; // Number of bytes returned in output buffer

	if ((wVol<0) || (wVol>127))
		return RDS_ERROR_INVALID_PARAMETER;

	fRet = DeviceIoControl(m_HwData.hDriver[m_HwData.nCurCardIdx],
                                    IOCTL_HW_SET_VOLUME,
									&wVol,2,
									NULL,0,
									&ReturnedLength,NULL);
	if (fRet)
		 return RDS_OK;
	else return RDS_ERROR;

}   


/*=============================================================================
FUNCTION: 	SetFrequency(DWORD dwFreq, TUNERSTATE* psState)
-------------------------------------------------------------------------------

PARAMETER: 	pointer to result (DWORD)
RETURNS:	RDS_OK if successful
=============================================================================*/
DWORD CTestAppDlg::SetFrequency(DWORD dwFreq)
{                        
	DWORD 	dwRet;
	BOOL	fRet;
    ULONG   ReturnedLength; // Number of bytes returned in output buffer

	if ((dwFreq<FREQ_MIN) || (dwFreq>FREQ_MAX))
		return RDS_ERROR_INVALID_PARAMETER;

	m_SR.bits.S24   = 0;					// preset mode		
	m_SR.bits.M22	= 0;					// stereo/mono mode
	m_SR.bits.B20_21= 0;					// FM band
	m_SR.bits.P19   = 1;   					// local/DX
	m_SR.bits.X18   = 0;					// not used
	m_SR.bits.S16_17= 0;					// search level
	m_SR.bits.X15   = 0;					// dummy
	m_SR.bits.F0_14 = (dwFreq+FM_IF)/FREQ_STEP_x10;
		

    fRet = DeviceIoControl(m_HwData.hDriver[m_HwData.nCurCardIdx],
                           IOCTL_OM5610_SET_FREQUENCY,
						   &m_SR.SR,sizeof(m_SR),
						   NULL,0,
						   &ReturnedLength,NULL);
	if (!fRet)		
		dwRet = GetLastError();
	
	return RDS_OK;

}   

/*=============================================================================
	GetFrequency
=============================================================================*/
DWORD CTestAppDlg::GetFrequency()
{      
	ULONG   SR;
	ULONG   ReturnedLength; // Number of bytes returned in output buffer
	CString szTxt;

    BOOL fRet = DeviceIoControl(m_HwData.hDriver[m_HwData.nCurCardIdx],
                                IOCTL_OM5610_GET_FREQUENCY,
								NULL,0,
								&SR,sizeof(SR),
								&ReturnedLength,NULL);

	DWORD dwRet = GetLastError();// 5 - ERROR_ACCESS_DENIED
	m_SR.SR = SR;
	
	m_CurFreq = (m_SR.bits.F0_14 * FREQ_STEP_x10)-FM_IF;
	UpdateData(FALSE);
	if ((m_CurFreq <FREQ_MIN) || (m_CurFreq >FREQ_MAX))
		return RDS_ERROR_INVALID_FREQUENCY;
	else
		return RDS_OK;
}



/*=============================================================================
  Function    : CTestAppDlg::OnHScroll
-------------------------------------------------------------------------------
  Description : 
  Returns     : void  -> 
  Parameters  : UINT nSBCode -> 
              : UINT nPos -> 
              : CScrollBar* pScrollBar -> 
-------------------------------------------------------------------------------
  Notes       : 
=============================================================================*/
void CTestAppDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{

	CSliderCtrl* pSlider;
	/*----------------------------------------------------------------------------
	// set frequency 
	-----------------------------------------------------------------------------*/

	if (pScrollBar == (CScrollBar*)&m_cSliderFreq)
	{
		m_CurFreq = m_cSliderFreq.GetPos();
		UpdateData(FALSE);
		SetFrequency(m_CurFreq);
		m_PS = "---";
		gfNewFreq = TRUE;
	}

	/*----------------------------------------------------------------------------
	// set volume
	-----------------------------------------------------------------------------*/
	pSlider = (CSliderCtrl*)GetDlgItem(IDC_VOL_SLIDER);
	if (pScrollBar == (CScrollBar*)pSlider)
	{
		SetVolume((WORD)pSlider->GetPos());
	}	

	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}


/*=============================================================================
	SEARCH
=============================================================================*/

void CTestAppDlg::OnSearchUp()   {OnSearch(1);}
void CTestAppDlg::OnSearchDown() {OnSearch(0);}

void CTestAppDlg::OnSearch(UCHAR fUp)
{	
	ULONG ReturnedLength;
	ULONG FreqBak,FreqDiff,nCnt=0;
	BOOL fRet;

	UpdateData(TRUE);

	m_SR.bits.S24   = 1;					// 0 = search mode (is set automaitcally in the driver)
	m_SR.bits.D23	= fUp;					// Search down = 0, up = 1
	m_SR.bits.M22	= 0;					// 0 = stereo
	m_SR.bits.B20_21= 0;					// 0 = FM band
	m_SR.bits.P19   = 1;					// 1 = DX
	m_SR.bits.X18   = 0;					// not used
	m_SR.bits.S16_17= 1;					// search level	(1 and 2 are swapped in OM5610)
	m_SR.bits.X15   = 0;					// dummy

	FreqBak = m_SR.bits.F0_14 = (m_CurFreq + FM_IF)/FREQ_STEP_x10;

	do
	{
		nCnt++;
		if (fUp)
			 m_SR.bits.F0_14 = FreqBak + (nCnt*4);	// offset 0
		else m_SR.bits.F0_14 = FreqBak - (nCnt*4);

		// Set frequency first: if you start a search at a strong station you will find the
		// current frequency again. Therefore set a deviating frequency first.
		fRet = DeviceIoControl(m_HwData.hDriver[m_HwData.nCurCardIdx],
                               IOCTL_OM5610_SET_FREQUENCY,
							   &m_SR.SR,sizeof(ULONG),
							   NULL,0,				// no output
							   &ReturnedLength,NULL);

		// Start search
		Sleep(50);

		TRACE("Send search control %d\n",nCnt);
		fRet = DeviceIoControl(m_HwData.hDriver[m_HwData.nCurCardIdx],
                               IOCTL_OM5610_SEARCH,
							   &m_SR.SR,sizeof(ULONG),
							   &m_SR.SR,sizeof(ULONG),
							   &ReturnedLength,NULL);

		if (!fRet )
		{
			AfxMessageBox("SEARCH ERROR");
//			break;
		}

		if (FreqBak > m_SR.bits.F0_14)
			 FreqDiff = FreqBak - m_SR.bits.F0_14;
		else FreqDiff = m_SR.bits.F0_14 -FreqBak;
	}
	while ((FreqDiff < 8) && (nCnt < 6));
	if (nCnt == 6)
	{
			AfxMessageBox("SEARCH ERROR - TOO CLOSE");
			return;
	}

	m_CurFreq = (m_SR.bits.F0_14 * FREQ_STEP_x10)-FM_IF;	// calculate the freqency 
	
	UpdateData(FALSE);
}



/*=============================================================================
  Function    : CTestAppDlg::OnSelchangeCards
-------------------------------------------------------------------------------
  Description : Selects and intializes another hardware device
  Returns     : void 
-------------------------------------------------------------------------------
  Notes       : 
=============================================================================*/
void CTestAppDlg::OnSelchangeCards() 
{
	int     nIdx;
	BOOL    fRet;
	ULONG   ReturnedLength;
	UCHAR	bData[3];


	if (m_wTimerID != 0)
	{
		timeKillEvent(m_wTimerID);
		m_wTimerID = 0;
	}
	CComboBox* pComboCards = (CComboBox* ) GetDlgItem(IDC_COMBO_CARDS);
	
	nIdx = pComboCards->GetCurSel();
	m_HwData.nCurCardIdx = nIdx;

	UpdateData(TRUE);
	SetVolume(m_CurVolume);
	SetFrequency(m_CurFreq);

	
	
	/*----------------------------------------------------------------------------
		Initialize RDS decoder
	-----------------------------------------------------------------------------*/

	bData[0] = 0xF0;	// RDS decoder inititalization commands
	bData[1] = 0x0F;
	bData[2] = 0x00;

    fRet = DeviceIoControl(m_HwData.hDriver[m_HwData.nCurCardIdx],
                          IOCTL_SAA6588_WRITE_IIC,
						  &bData,sizeof(bData),
						  NULL,0,
						  &ReturnedLength,NULL);



	m_wTimerID = timeSetEvent(15,0,TimerCallBack,(DWORD)this,TIME_PERIODIC);

	
}


