/*=============================================================================
   FILE:         Main.cpp
-------------------------------------------------------------------------------
   DESCRIPTION:  WinMain and DlgProc for main dialog
   AUTHOR:       F.M.Birth
   HISTORY:      18-8-1999
   NOTES:        This project does not use MFC !
-------------------------------------------------------------------------------
   COPYRIGHT:    (c) 1999-2005, TerraTec Electronic GmbH. All Rights Reserved.

                 Information in this file is the intellectual property of
                 TerraTec Electronic GmbH, and contains trade secrets
                 that must be stored and viewed confidentially.
                 By viewing, using, modifying and compiling 
                 the programming code below you acknowledge you have read,
                 accepted and executed the Software licensing agreement 
                 your company has established with TerraTec Electronic GmbH.
=============================================================================*/

#include <Windows.h>
#include "Resource.h"
#include "TTApi_FM.h"
#include "TTApi_RDS.h"
#include "MainWnd.h"
#include "Main.h"

CMainWnd Dlg; // main dialog object

/*=============================================================================
  Function    : WinMain
-------------------------------------------------------------------------------
  Description : Creation of the Main Window and About Box
  Returns     : int WINAPI  -> 
  Parameters  : HINSTANCE hInst -> 
              : HINSTANCE hPrevInstance -> 
              : LPSTR lpCmdLine -> 
              : int nCmdShow -> 
-------------------------------------------------------------------------------
  Notes       : 
=============================================================================*/
int WINAPI WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	MSG 		msg;

	// Allow only one instance of htis application
	HANDLE hMutex = CreateMutex(NULL,TRUE,"TTCTRL_MUTEX");
	if( GetLastError()== ERROR_ALREADY_EXISTS)
		return FALSE;

	// Create the main window
	Dlg.m_hInstance = hInst;
	Dlg.m_hWnd = CreateDialog(hInst,MAKEINTRESOURCE(IDD_RADIO),NULL,(DLGPROC)DlgProc);
	if (Dlg.m_hWnd==NULL)
		return FALSE;

	// the! message loop

	while (GetMessage(&msg, NULL,0,0))
	{
		if (!IsDialogMessage( Dlg.m_hWnd,&msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return msg.wParam;   
}


/*=============================================================================
  Function    : DlgProc
-------------------------------------------------------------------------------
  Description : Main message queue
  Returns     : BOOL CALLBACK  -> 
  Parameters  : HWND hDlg -> 
              : UINT uMsg -> 
              : WPARAM wParam -> 
              : LPARAM lParam -> 
-------------------------------------------------------------------------------
  Notes       : 
=============================================================================*/
BOOL CALLBACK DlgProc(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	static BOOL fMute = FALSE;
	int nListIdx;
	
	switch(uMsg)
	{
	case WM_INITDIALOG:
		Dlg.OnInitDialog();
		return FALSE;

	case WM_TIMER:
		Dlg.OnTimer(wParam);
		break;

	case WM_COMMAND: 
		switch LOWORD(wParam)
		{
		case IDC_COMBO_SELECT_CARD:
			switch (HIWORD(wParam)) 
            { 
				case LBN_SELCHANGE: 
					OutputDebugString("SelChange\n");
					nListIdx = SendMessage((HWND)lParam,CB_GETCURSEL,0,0);
					Dlg.OnNewHardware(nListIdx);
					break;
			}
			break;
 		case IDC_PRESET_MIN:
			Dlg.m_dwFreq = FREQ_MIN;
			Dlg.SetFrequency(Dlg.m_dwFreq,&Dlg.TunerState);
			break;
		case IDC_PRESET_MAX:
			Dlg.m_dwFreq = FREQ_MAX;
			Dlg.SetFrequency(Dlg.m_dwFreq,&Dlg.TunerState);
			break;

		case IDC_LEVEL_0:
		case IDC_LEVEL_1:
		case IDC_LEVEL_2:
		case IDC_LEVEL_3:
			Dlg.TunerState.bits.Level = LOWORD(wParam)-IDC_LEVEL_0;
			break;
		case IDC_MONO:
			if (IsDlgButtonChecked(Dlg.m_hWnd,IDC_MONO))
			  	 Dlg.TunerState.bits.StereoMode = FALSE;
			else Dlg.TunerState.bits.StereoMode = TRUE;
			Dlg.SetFrequency(Dlg.m_dwFreq,&Dlg.TunerState);
			break;
		case IDC_LOCAL:
			if (IsDlgButtonChecked(Dlg.m_hWnd,IDC_LOCAL))
			  	 Dlg.TunerState.bits.DX = FALSE;
			else Dlg.TunerState.bits.DX = TRUE;
			Dlg.SetFrequency(Dlg.m_dwFreq,&Dlg.TunerState);
			break;

		case IDC_SEARCH_DOWN:
		case IDC_SEARCH_UP:
			Dlg.OnSearch(LOWORD(wParam)-IDC_SEARCH_DOWN);
			break;

		case IDC_VOL_MUTE:
			fMute = (fMute +1)%2;
			VolumeMute(Dlg.m_nDevIdx,fMute);
			break;
		}
		return TRUE;

	case WM_HSCROLL:
		switch (GetDlgCtrlID((HWND)lParam))
		{
		case IDC_SLIDER_FREQ:
			Dlg.OnSliderFreq((int)LOWORD(wParam),(short int) HIWORD(wParam));
			break;
		case IDC_SLIDER_VOL:
			Dlg.OnSliderVol ((int)LOWORD(wParam),(short int) HIWORD(wParam));
			break;
		}
		return FALSE;

	case WM_SYSCOMMAND:
		switch (wParam) 
		{
		case SC_CLOSE:
			PostMessage(Dlg.m_hWnd,WM_CLOSE,NULL,NULL);
			return TRUE;
		}
	
		// must be FALSE for moving !!!!
		return FALSE;
	
	case WM_CLOSE:
		VolumeMute(Dlg.m_nDevIdx,FALSE);
		RDS_Stop(Dlg.m_nDevIdx);
		DestroyWindow(Dlg.m_hWnd);
		PostQuitMessage(0);
		return TRUE;

	}
	return FALSE;
}


/*=============================================================================
  Function    : DB
-------------------------------------------------------------------------------
  Description : generates a formatted debug output
  Returns     : void  -> 
  Parameters  : LPSTR lpszDebugString -> 
              : ... -> 
-------------------------------------------------------------------------------
  Notes       : DEBUG_STRING must be defined
=============================================================================*/
#define DEBUG_STRING "API Sample:"
void DB(LPSTR lpszDebugString, ...)
{     
#ifdef _DEBUG
	char szBuffer[100];
   sprintf(szBuffer,"%s\t", DEBUG_STRING);
   wvsprintf(szBuffer+lstrlen(szBuffer),lpszDebugString,(LPSTR)(&lpszDebugString+1));
   lstrcat(szBuffer, "\r\n");
   OutputDebugString(szBuffer);
#endif    
}
