// MessageDlg.h : Declaration of the CMessageDlg

#ifndef __MESSAGEDLG_H_
#define __MESSAGEDLG_H_

#include "resource.h"       // main symbols
#include <atlhost.h>

class CNotify;


#define DIALOG_SETUPFIRECRACKER 0
#define DIALOG_SETUPRECEIVER 3

#define DIALOG_MODAL 0


/////////////////////////////////////////////////////////////////////////////
// CMessageDlg
class CMessageDlg : 
	public CAxDialogImpl<CMessageDlg>
{
public:
	CMessageDlg()
	{
        FinalConstruct();
	}

	~CMessageDlg()
	{
        FinalRelease();
	}

	enum { IDD = IDD_MESSAGEDLG };

BEGIN_MSG_MAP(CMessageDlg)
	MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
	COMMAND_ID_HANDLER(IDOK, OnOK)
	COMMAND_ID_HANDLER(IDCANCEL, OnCancel)
	COMMAND_HANDLER(IDC_SETUP, BN_CLICKED, OnClickedSetup)
    COMMAND_HANDLER(IDC_SETUPRECV, BN_CLICKED, OnClickedSetupRecv )
	COMMAND_HANDLER(IDOK, BN_CLICKED, OnOK)
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);

    HRESULT FinalConstruct();

    void FinalRelease();

    STDMETHOD(X10Command)(
                            BSTR bszCommand, 
                            EX10Command eCommand, 
                            long lAddress, 
                            EX10Key eKeyState, 
                            long lSequence, 
                            EX10Comm eCommandType, 
                            VARIANT varTimestamp)
	{
        CHAR szCommand[ 256 ];
        LPSTR pszKeyState;
        if (eKeyState == X10KEY_ON) {
            pszKeyState = "Key Down";
        } else if (eKeyState == X10KEY_OFF) {
            pszKeyState = "Key Up";
        } else {
            pszKeyState = "Key Repeat";
        }
        //if ((eCommandType == X10COMM_ON) || (eCommandType == X10COMM_OFF)) {
            wsprintf( szCommand, "%s: %c%d %ls, Sequence %d", pszKeyState, (char) (lAddress >> 4) + 'A', (DWORD) (lAddress & 0xF) + 1, bszCommand, lSequence );
        //} else {
        //    wsprintf( szCommand, "%ls", bszCommand );
        //}
        SendDlgItemMessage( IDC_LIST, LB_INSERTSTRING, 0, (LPARAM) szCommand );
        SendDlgItemMessage( IDC_LIST, LB_DELETESTRING, 100, 0 );
        return S_OK;
    }

	LRESULT OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
	{
        CenterWindow();
		return 1;  // Let the system set the focus
	}

	LRESULT OnOK(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
	{
        //DestroyWindow();
		EndDialog(wID);
		return 0;
	}

	LRESULT OnCancel(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
	{
        //DestroyWindow();
		EndDialog(wID);
		return 0;
	}

	LRESULT OnClickedSetup(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
    {
        if (pX10) {
            CComPtr< IX10DirectInterface > pDirectInterface;
            LONG lRet;
            pX10->QueryInterface( __uuidof(IX10DirectInterface), (LPVOID *) &pDirectInterface );
            if (pDirectInterface) {
                pDirectInterface->DialogControl( (LONG) m_hWnd, DIALOG_SETUPFIRECRACKER, DIALOG_MODAL, &lRet );
            }
        }
		return 0;
	}

	LRESULT OnClickedSetupRecv(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
    {
        if (pX10) {
            CComPtr< IX10DirectInterface > pDirectInterface;
            LONG lRet;
            pX10->QueryInterface( __uuidof(IX10DirectInterface), (LPVOID *) &pDirectInterface );
            if (pDirectInterface) {
                pDirectInterface->DialogControl( (LONG) m_hWnd, DIALOG_SETUPRECEIVER, DIALOG_MODAL, &lRet );
            }
        }
		return 0;
	}

	DWORD dwCookie;

    CComPtr< IX10Interface > pX10;

	CComPtr< _IX10InterfaceEvents > pI;

	CComObject<CNotify> *pNotify;

};

#endif //__MESSAGEDLG_H_
