// MessageDlg.cpp : Implementation of CMessageDlg
#include "stdafx.h"
#include "Eventview.h"
#include "MessageDlg.h"
#include "notify.h"


HRESULT CMessageDlg::FinalConstruct() {

	HRESULT hr = CComObject<CNotify>::CreateInstance(&pNotify);
    pNotify->pdlg = this;

    if (FAILED(pX10.CoCreateInstance(__uuidof(X10Interface)))) {
		ATLTRACE(_T("Create instance failed"));
    }

    if (FAILED(pNotify->QueryInterface(__uuidof(_IX10InterfaceEvents), reinterpret_cast<void**>(&pI)))) {
		ATLTRACE(_T("QI for event interface failed"));
    }

    if (FAILED(AtlAdvise( pX10, pI, __uuidof(_IX10InterfaceEvents), &dwCookie))) {
		ATLTRACE(_T("Advise failed"));
    }

    return S_OK;
}


void CMessageDlg::FinalRelease() {

    if (pX10) {
		AtlUnadvise(pX10,__uuidof(_IX10InterfaceEvents),dwCookie );
        pX10.Release();
    }
    pI.Release();
}



/////////////////////////////////////////////////////////////////////////////
// CMessageDlg
