// Notify.h : Declaration of the CNotify

#ifndef __NOTIFY_H_
#define __NOTIFY_H_

#include "resource.h"       // main symbols
#include "messagedlg.h"


/////////////////////////////////////////////////////////////////////////////
// CNotify
class ATL_NO_VTABLE CNotify : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CNotify, &CLSID_NULL>,
	public _IX10InterfaceEvents
{
public:
	CNotify()
	{
        pdlg = NULL;
	}

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CNotify)
	COM_INTERFACE_ENTRY(_IX10InterfaceEvents)
END_COM_MAP()

// INotify
public:
    STDMETHOD(X10Command)(
                            BSTR bszCommand, 
                            EX10Command eCommand, 
                            long lAddress, 
                            EX10Key eKeyState, 
                            long lSequence, 
                            EX10Comm eCommandType, 
                            VARIANT varTimestamp)
	{
        if (pdlg) {
            pdlg->X10Command( bszCommand, eCommand, lAddress, eKeyState, lSequence, eCommandType, varTimestamp );
        }
		return S_OK;
	}

	STDMETHOD(X10HelpEvent)( LONG hwndDialog, LONG lHelpID) {

        CHAR szMsg[ 256 ];
        wsprintf( szMsg, "Help ID %d signalled!", lHelpID );
        MessageBox( (HWND) hwndDialog, szMsg, "EventView Sample", MB_ICONINFORMATION | MB_OK );
		return S_OK;
	}

    CMessageDlg *pdlg;

};

#endif //__NOTIFY_H_
